<?php

require 'config.php';

$settings = new Settings(!empty($_GET['save']));

if (!empty($db_config) && (isset($db_config[1]))) {
    // if we have database details, disable any of the database details that aren't properly setup
    foreach ($db_config[1] as $db_config_name => $database_configuration) {
        if (empty($database_configuration['hostname']) ||
            empty($database_configuration['database']) ||
            empty($database_configuration['username']) ||
            empty($database_configuration['password'])) {
            $settings->DisableCoreSuboption('web_database_connection_target', $db_config_name);
        }
    }
}

// used to map notice and danger to the bootstrap CSS names for the alerts
$bootstrap_names = array(
    'error' => 'danger',
    'notice' => 'info',
);

// load options
$core_options = $settings->GetCoreOptions();
if (empty($core_options)) {
    $settings->AddConfigurationError('error', 'No core settings found');
}
$script_options = $settings->GetScriptOptions();
if (empty($script_options)) {
    $settings->AddConfigurationError('notice', 'No script settings found');
}

// generic function to output options based on the type
function OutputOption($option)
{
    switch (strtolower($option['type'])) {
        case 'checkbox':
            $checked = strtolower($option['value']) == 'false' ? null : 'checked=""';
            echo "<input type='hidden' value='0' name='{$option['name']}'><div class='form-check setting'><input class='form-check-input text-right' type='checkbox' id='{$option['name']}' {$checked} name='{$option['name']}'><label class='form-check-label' for='{$option['name']}'>Enabled</label></div>";
            break;
        case 'text':
            echo "<input type='text' class='text-right' name='{$option['name']}' value='{$option['value']}'>";
            break;
        case 'select':
            echo "<select type='{$option['type']}' class='text-right' name='{$option['name']}'>";
            foreach ($option['suboptions'] as $suboption) {
                echo '<option ' . (!empty($suboption['value']) ? "value='{$suboption['value']}'" : 'value') . ($suboption['enabled'] ? '' : ' disabled') . (!empty($option['value']) && $option['value'] == $suboption['value'] ? ' selected' : '') . '>' . $suboption['label'] . '</option>';
            }
            echo '</select>';
            break;
        case 'number':
            echo "<input type='number' class='text-right' name='{$option['name']}' value='{$option['value']}'>";
            break;
        case 'date':
            echo "<input type='date' class='text-right' name='{$option['name']}' value='{$option['value']}'>";
            break;
        default:
            // unknown option type - do nothing further for it
            break;
    }
}

?>
<!DOCTYPE html>
<html lang="en-GB">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
    <title>OrderWise Settings</title>
    <link rel="stylesheet" href="assets/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/Navigation-Clean.css">
    <!-- styles.css contains the CSS specific to the settings script -->
    <link rel="stylesheet" href="assets/css/styles.css">
</head>

<body>
<nav class="navbar navbar-light navbar-expand-md navigation-clean" id="settings-nav">
    <div class="container"><a class="navbar-brand" href="#">OrderWise - Script Setting Manager</a>
        <button data-toggle="collapse" class="navbar-toggler" data-target="#navcol-1"><span class="sr-only">Toggle navigation</span><span
                    class="navbar-toggler-icon"></span></button>
        <div
                class="collapse navbar-collapse" id="navcol-1">
            <ul class="nav navbar-nav ml-auto">
                <?php
                // output the following scripts to the navbar (if they exist)
                if (file_exists('orders.php')) {
                    echo '<li class="nav-item text-right" role="presentation"><a class="nav-link" href="orders.php"
                                                                           target="_blank">Orders Script</a></li>';
                }
                if (file_exists('despatch.php')) {
                    echo '<li class="nav-item text-right" role="presentation"><a class="nav-link" href="despatch.php"
                                                                           target="_blank">Despatch Script</a></li>';
                }
                if (file_exists('price.php')) {
                    echo '<li class="nav-item text-right" role="presentation"><a class="nav-link" href="price.php"
                                                                           target="_blank">Price Script</a></li>';
                }
                if (file_exists('stock.php')) {
                    echo '<li class="nav-item text-right" role="presentation"><a class="nav-link" href="stock.php"
                                                                           target="_blank">Stock Script</a></li>';
                }
                if (file_exists('product.php')) {
                    echo '<li class="nav-item text-right" role="presentation"><a class="nav-link" href="product.php"
                                                                           target="_blank">Product Script</a></li>';
                } ?>
            </ul>
        </div>
    </div>
</nav>
<section class="container">
    <section id="configuration">
        <h1>Core Settings:</h1>
        <?php
        // error types: success, info, warning, danger (error)
        foreach ($settings->GetConfigurationErrors() as $error) { ?>
            <div class="alert alert-<?php echo isset($bootstrap_names[strtolower($error['type'])]) ? $bootstrap_names[strtolower($error['type'])] : strtolower($error['type']) ?>"
                 role="alert">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span
                            aria-hidden="true">×</span></button>
                <span><strong><?php echo ucwords($error['type']) ?>:&nbsp;</strong><?php echo $error['message'] ?></span>
            </div>
        <?php } ?>
        <?php
        if (!empty($core_options)) {
            ?>
            <form enctype="application/x-www-form-urlencoded" action="?save=core#configuration" method="post">
                <?php foreach ($core_options as $option) { ?>
                    <h5 class="text-left"><?php echo $option['label'] ?></h5>
                    <div class="row flex-grow-1 flex-fill">
                        <div class="col">
                            <p class="form-description"><?php echo str_replace('\n', '<br>', htmlspecialchars($option['description'])) ?></p>
                        </div>
                        <div class="col text-right flex-grow-0">
                            <?php
                            OutputOption($option);
                            ?>
                        </div>
                    </div>
                    <hr>
                <?php } ?>
                <div class="row">
                    <div class="col">
                        <input type="submit" class="btn btn-primary float-right"
                               value="Save Core Settings">
                    </div>
                </div>
                <br>
            </form>
        <?php } ?>
    </section>
    <section id="options">
        <?php
        if (!empty($script_options)) {
            echo '<h1>Script Settings:</h1>';
        }
        ?>
        <?php
        // error types: success, info, warning, danger (error)
        foreach ($settings->GetScriptErrors() as $error) { ?>
            <div class="alert alert-<?php echo isset($bootstrap_names[strtolower($error['type'])]) ? $bootstrap_names[strtolower($error['type'])] : strtolower($error['type']) ?>"
                 role="alert">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span
                            aria-hidden="true">×</span></button>
                <span><strong><?php echo ucwords($error['type']) ?>:&nbsp;</strong><?php echo $error['message'] ?></span>
            </div>
        <?php } ?>
        <?php
        if (!empty($script_options)) {
            ?>
            <form enctype="application/x-www-form-urlencoded" action="?save=script#options" method="post">
                <?php foreach ($script_options as $name => $option) { ?>
                    <h5 class="text-left"><?php echo $option['label'] ?></h5>
                    <div class="row">
                        <div class="col">
                            <p class="form-description"><?php echo str_replace('\n', '<br>', htmlspecialchars($option['description'])) ?></p>
                        </div>
                        <div class="col text-right flex-grow-0">
                            <?php
                            OutputOption($option);
                            ?>
                        </div>
                    </div>
                    <hr>
                <?php } ?>
                <div class="row">
                    <div class="col">
                        <input type="submit" class="btn btn-primary float-right"
                               value="Save Script Settings">
                    </div>
                </div>
                <br>
            </form>
        <?php } ?>
    </section>
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/bootstrap/js/bootstrap.min.js"></script>
</body>
</html>