<?php
// Server configuration
header('Expires: '.gmdate('D, d M Y H:i:s').' GMT');
header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
header('Cache-Control: no-store, no-cache, must-revalidate');
header('Cache-Control: post-check=0, pre-check=0', false);
header('Pragma: no-cache');
error_reporting(E_ALL & ~E_NOTICE);
ini_set('error_log', 'phperror.log');
set_time_limit(600);
date_default_timezone_set('Europe/London');


// Set the server environment - don't use SetEnv as we can't always rely on php.ini or .htaccess being available/honoured
$x = (substr($_SERVER['DOCUMENT_ROOT'],0,15) == 'C:/xampp/htdocs') ? 'development' : 'production';
define('ENVIRONMENT',$x);
spl_autoload_register('AutoLoader');


// Database connection details ... db_config[StoreId]
$settings = new Settings();
$ecom = new Handler();
$db_config = array();
$db_config[1] = array(	'development' => array(
							'hostname'		=> 'localhost',
							'username'		=> 'webshops',
							'password'		=> 'username',
							'database'		=> 'ecom_scripts_testing',
							'utf8'			=> true,
							'table_prefix'	=> ''
						),
						'staging' => array(
							'hostname'		=> 'localhost',
							'username'		=> 'cesteven_ows',
							'password'		=> 'vkW2ohVWP8s$',
							'database'		=> 'cesteven_orderwise',
							'utf8'			=> true,
							'table_prefix'	=> 'shopify_staging_'
						),
						'production' => array(
							'hostname'		=> 'localhost',
							'username'		=> 'cesteven_ows',
							'password'		=> 'vkW2ohVWP8s$',
							'database'		=> 'cesteven_orderwise',
							'utf8'			=> true,
							'table_prefix'	=> 'shopify_live_'
						)
);


// Set the response XML message types based on those orderwise presently accepts
define('XML_REPONSE_TYPE_LOG','Log');
define('XML_REPONSE_TYPE_WARNING','Warning');
define('XML_REPONSE_TYPE_ERROR','Error');


// Set the auto created directories. Housekeeping by Handler::DirectoryManagement()
$ecom->SetDirectory('exports_archive', 'data/owexport_archive/');
$ecom->SetDirectory('logs', 'logs/');
$ecom->DirectoryManagement();


// Load the configuration settings handled by settings.php
$ecom->LoadConfiguration($settings);


// If this is the setup script calling we don't need to apply any further processing
$arr = explode('/',$_SERVER['SCRIPT_FILENAME']);
if (end($arr) == 'settings.php') return;


// Allows for multiple stores to run one set of scripts by passing
// the store id in the url which in turn links to the appropriate database
$x = (isset($_GET['store']) && is_numeric($_GET['store'])) ? $_GET['store'] : 1;
$ecom->SetStoreId($x);
$db_mode = $ecom->GetDbMode();
$store_id = $ecom->GetStoreId();
WriteToLog('Running store id: '.$store_id);


// Configure the database connection based on the store id if used
if ($db_mode == 'development' || $db_mode == 'staging' || $db_mode == 'production') {
	// If the store id doesn't map to a database connection, we default to using the main connection
	if (!isset($db_config[$store_id][$db_mode])) {
		$db_config[$store_id] = $db_config[1];
	}

	// Confirm we've set the database details in this script
	if ($db_config[$store_id][$db_mode]['hostname'] == '' ||
		$db_config[$store_id][$db_mode]['database'] == '' ||
		$db_config[$store_id][$db_mode]['username'] == '' ||
		$db_config[$store_id][$db_mode]['password'] == '') {
		$ecom->AppendResponseMessage(XML_REPONSE_TYPE_ERROR, 'Script Terminated: Database target not configured in config.php.');
		$ecom->ReturnResponseXML();
	}

	// Connect with the database and set this in the handler
	try {
		$db = new Database($db_config[$store_id][$db_mode]);
		$ecom->SetDatabase($db);
	}
	catch (Exception $e) {
		$ecom->AppendResponseMessage(XML_REPONSE_TYPE_ERROR, $e->getMessage());
		$ecom->ReturnResponseXML();
	}
	
	// Create the holding table for successfully imported order ids
	if (!$db->Query('	CREATE TABLE IF NOT EXISTS ' . $ecom::OWS_IMPORTED_ORDER_TABLE_NAME . ' (
								id int unsigned NOT NULL auto_increment PRIMARY KEY,
								order_id VARCHAR(50) NOT NULL,
								store_id INT NOT NULL,
								date_imported DATETIME,
								INDEX(order_id),
								INDEX(store_id),
								INDEX(date_imported)) ENGINE=InnoDB DEFAULT CHARSET=utf8;')) {
		$ecom->AppendResponseMessage(XML_REPONSE_TYPE_ERROR, 'Script Terminated: Unable to create ows_imported_order');
		$ecom->ReturnResponseXML();
	}
}
else if ($db_mode != 'none') {
	// If we've indicated we're using a database but haven't set the details
	// 'none' will generally be set if we're using an API
    $ecom->AppendResponseMessage(XML_REPONSE_TYPE_ERROR, 'Script Terminated: Database target not set in settings.php.');
	$ecom->ReturnResponseXML();
}


// Register the shutdown function to enable the logging of an interrupted script.
register_shutdown_function('ScriptComplete',microtime(true),$ecom->GetDirectory('logs'),getcwd());
function ScriptComplete($script_start_time,$log_fn,$cwd)
{
	$arr = explode('/',$_SERVER['SCRIPT_FILENAME']);
	$script = $arr[sizeof($arr)-1];

	$t = number_format(microtime(true) - $script_start_time,0,'','');
	$m = floor($t/60);
	$time = $m.'m '.($t - ($m*60)).'s';
	$msg = date('d/m/Y H:i:s')."; $script; Script complete - run time $time\n\n";

	if ($fp = fopen($cwd.'/logs/activity.'.date('Ymd').'.txt', 'a')) {
		fwrite($fp,$msg);
		fclose($fp);
	}
}

function AutoLoader($class)
{
	$fn = './class.'.strtolower($class).'.php';
	if (file_exists($fn)) {
		require $fn;
	}
}

function WriteToLog($msg)
{
	if ($fp = @fopen('logs/activity.'.date('Ymd').'.txt', 'a')) {
		$arr = explode('/',$_SERVER['SCRIPT_FILENAME']);
		$script = end($arr);
		fwrite($fp,date('d/m/Y H:i:s')."; $script; $msg\n");
		fclose($fp);
	}
}

function dump($x)
{
    if (!headers_sent()) header('content-type: text/plain; charset=utf-8'); // prevent horrible formatting
    echo sprintf('<pre>%s</pre>',print_r($x,true));
}

function dd($x)
{
    dump($x);
    exit;
}