<?php

//22/05/2019 | TL | Dev 43368 | Script Edit to handle multiple stock locations | helper function to check if multiple stock locations used
//01/07/2019 | DS | Dev 43934 | Script amended to include more than just a true or false value. Added try catch for Shopify initialisation
//                              and added full stock location data from the API


require './config.php';

try {
$shopify = new Shopify($ecom->GetStoreId(), $settings);
} catch (Exception $e) {
    echo "Error getting stock locations with error: {$e->getMessage()}";
    die;
}


$multiple_stock_locations = $shopify->IsMultipleStockLocation();

print('<p>Multiple stock locations: ' . ($multiple_stock_locations ? 'true' : 'false') . '</p>');

// Output all stock locations for the store
foreach ($shopify->GetLoadedStockLocations() as $index => $stock_location) {
    echo "<br><p>Stock location #{$index}:<br>";
    // Output the lines of data set against the stock location(s) and the name of the field being outputted
    foreach ($stock_location as $name => $data)
        print_r((string)ucfirst($name) . ': ' . (string)$data . "<br>");
    echo '</p>';
}